/*
* hal_cover_reg.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/


#ifndef __HAL_COVER_REG_H__
#define __HAL_COVER_REG_H__

#define BK_BASE_REG(reg)               ((reg) * 2)

#define REG_COVER_00                BK_BASE_REG(0x00)
#define REG_COVER_01                BK_BASE_REG(0x01)
#define REG_COVER_02                BK_BASE_REG(0x02)
#define REG_COVER_03                BK_BASE_REG(0x03)
#define REG_COVER_04                BK_BASE_REG(0x04)
#define REG_COVER_05                BK_BASE_REG(0x05)
#define REG_COVER_06                BK_BASE_REG(0x06)
#define REG_COVER_07                BK_BASE_REG(0x07)
#define REG_COVER_08                BK_BASE_REG(0x08)
#define REG_COVER_09                BK_BASE_REG(0x09)
#define REG_COVER_0A                BK_BASE_REG(0x0A)
#define REG_COVER_0B                BK_BASE_REG(0x0B)
#define REG_COVER_0C                BK_BASE_REG(0x0C)
#define REG_COVER_0D                BK_BASE_REG(0x0D)
#define REG_COVER_0E                BK_BASE_REG(0x0E)
#define REG_COVER_0F                BK_BASE_REG(0x0F)

#define REG_COVER_10                BK_BASE_REG(0x10)
#define REG_COVER_11                BK_BASE_REG(0x11)
#define REG_COVER_12                BK_BASE_REG(0x12)
#define REG_COVER_13                BK_BASE_REG(0x13)
#define REG_COVER_14                BK_BASE_REG(0x14)
#define REG_COVER_15                BK_BASE_REG(0x15)
#define REG_COVER_16                BK_BASE_REG(0x16)
#define REG_COVER_17                BK_BASE_REG(0x17)
#define REG_COVER_18                BK_BASE_REG(0x18)
#define REG_COVER_19                BK_BASE_REG(0x19)
#define REG_COVER_1A                BK_BASE_REG(0x1A)
#define REG_COVER_1B                BK_BASE_REG(0x1B)
#define REG_COVER_1C                BK_BASE_REG(0x1C)
#define REG_COVER_1D                BK_BASE_REG(0x1D)
#define REG_COVER_1E                BK_BASE_REG(0x1E)
#define REG_COVER_1F                BK_BASE_REG(0x1F)

#define REG_COVER_20                BK_BASE_REG(0x20)
#define REG_COVER_21                BK_BASE_REG(0x21)
#define REG_COVER_22                BK_BASE_REG(0x22)
#define REG_COVER_23                BK_BASE_REG(0x23)
#define REG_COVER_24                BK_BASE_REG(0x24)
#define REG_COVER_25                BK_BASE_REG(0x25)
#define REG_COVER_26                BK_BASE_REG(0x26)
#define REG_COVER_27                BK_BASE_REG(0x27)
#define REG_COVER_28                BK_BASE_REG(0x28)
#define REG_COVER_29                BK_BASE_REG(0x29)
#define REG_COVER_2A                BK_BASE_REG(0x2A)
#define REG_COVER_2B                BK_BASE_REG(0x2B)
#define REG_COVER_2C                BK_BASE_REG(0x2C)
#define REG_COVER_2D                BK_BASE_REG(0x2D)
#define REG_COVER_2E                BK_BASE_REG(0x2E)
#define REG_COVER_2F                BK_BASE_REG(0x2F)

#define REG_COVER_30                BK_BASE_REG(0x30)
#define REG_COVER_31                BK_BASE_REG(0x31)
#define REG_COVER_32                BK_BASE_REG(0x32)
#define REG_COVER_33                BK_BASE_REG(0x33)
#define REG_COVER_34                BK_BASE_REG(0x34)
#define REG_COVER_35                BK_BASE_REG(0x35)
#define REG_COVER_36                BK_BASE_REG(0x36)
#define REG_COVER_37                BK_BASE_REG(0x37)
#define REG_COVER_38                BK_BASE_REG(0x38)
#define REG_COVER_39                BK_BASE_REG(0x39)
#define REG_COVER_3A                BK_BASE_REG(0x3A)
#define REG_COVER_3B                BK_BASE_REG(0x3B)
#define REG_COVER_3C                BK_BASE_REG(0x3C)
#define REG_COVER_3D                BK_BASE_REG(0x3D)
#define REG_COVER_3E                BK_BASE_REG(0x3E)
#define REG_COVER_3F                BK_BASE_REG(0x3F)

#define REG_COVER_40                BK_BASE_REG(0x40)
#define REG_COVER_41                BK_BASE_REG(0x41)
#define REG_COVER_42                BK_BASE_REG(0x42)
#define REG_COVER_43                BK_BASE_REG(0x43)
#define REG_COVER_44                BK_BASE_REG(0x44)
#define REG_COVER_45                BK_BASE_REG(0x45)
#define REG_COVER_46                BK_BASE_REG(0x46)
#define REG_COVER_47                BK_BASE_REG(0x47)
#define REG_COVER_48                BK_BASE_REG(0x48)
#define REG_COVER_49                BK_BASE_REG(0x49)
#define REG_COVER_4A                BK_BASE_REG(0x4A)
#define REG_COVER_4B                BK_BASE_REG(0x4B)
#define REG_COVER_4C                BK_BASE_REG(0x4C)
#define REG_COVER_4D                BK_BASE_REG(0x4D)
#define REG_COVER_4E                BK_BASE_REG(0x4E)
#define REG_COVER_4F                BK_BASE_REG(0x4F)

#define REG_COVER_50                BK_BASE_REG(0x50)
#define REG_COVER_51                BK_BASE_REG(0x51)
#define REG_COVER_52                BK_BASE_REG(0x52)
#define REG_COVER_53                BK_BASE_REG(0x53)
#define REG_COVER_54                BK_BASE_REG(0x54)
#define REG_COVER_55                BK_BASE_REG(0x55)
#define REG_COVER_56                BK_BASE_REG(0x56)
#define REG_COVER_57                BK_BASE_REG(0x57)
#define REG_COVER_58                BK_BASE_REG(0x58)
#define REG_COVER_59                BK_BASE_REG(0x59)
#define REG_COVER_5A                BK_BASE_REG(0x5A)
#define REG_COVER_5B                BK_BASE_REG(0x5B)
#define REG_COVER_5C                BK_BASE_REG(0x5C)
#define REG_COVER_5D                BK_BASE_REG(0x5D)
#define REG_COVER_5E                BK_BASE_REG(0x5E)
#define REG_COVER_5F                BK_BASE_REG(0x5F)

#define REG_COVER_60                BK_BASE_REG(0x60)
#define REG_COVER_61                BK_BASE_REG(0x61)
#define REG_COVER_62                BK_BASE_REG(0x62)
#define REG_COVER_63                BK_BASE_REG(0x63)
#define REG_COVER_64                BK_BASE_REG(0x64)
#define REG_COVER_65                BK_BASE_REG(0x65)
#define REG_COVER_66                BK_BASE_REG(0x66)
#define REG_COVER_67                BK_BASE_REG(0x67)
#define REG_COVER_68                BK_BASE_REG(0x68)
#define REG_COVER_69                BK_BASE_REG(0x69)
#define REG_COVER_6A                BK_BASE_REG(0x6A)
#define REG_COVER_6B                BK_BASE_REG(0x6B)
#define REG_COVER_6C                BK_BASE_REG(0x6C)
#define REG_COVER_6D                BK_BASE_REG(0x6D)
#define REG_COVER_6E                BK_BASE_REG(0x6E)
#define REG_COVER_6F                BK_BASE_REG(0x6F)

#define REG_COVER_70                BK_BASE_REG(0x70)
#define REG_COVER_71                BK_BASE_REG(0x71)
#define REG_COVER_72                BK_BASE_REG(0x72)
#define REG_COVER_73                BK_BASE_REG(0x73)
#define REG_COVER_74                BK_BASE_REG(0x74)
#define REG_COVER_75                BK_BASE_REG(0x75)
#define REG_COVER_76                BK_BASE_REG(0x76)
#define REG_COVER_77                BK_BASE_REG(0x77)
#define REG_COVER_78                BK_BASE_REG(0x78)
#define REG_COVER_79                BK_BASE_REG(0x79)
#define REG_COVER_7A                BK_BASE_REG(0x7A)
#define REG_COVER_7B                BK_BASE_REG(0x7B)
#define REG_COVER_7C                BK_BASE_REG(0x7C)
#define REG_COVER_7D                BK_BASE_REG(0x7D)
#define REG_COVER_7E                BK_BASE_REG(0x7E)
#define REG_COVER_7F                BK_BASE_REG(0x7F)

#define REG_ISP_COVER_BASE_0     0x122D00 // for SCL0 & SCL1
#define REG_ISP_COVER_BASE_1     0x122E00 // for SCL2 & SCL3
#define REG_DIP_COVER_BASE       0x123D00

// ISP COVER settings
#define REG_ISPSC0_COVER_SW_RESET REG_COVER_01
#define REG_ISPSC1_COVER_SW_RESET REG_COVER_41
#define REG_ISPSC2_COVER_SW_RESET REG_COVER_01
#define REG_ISPSC3_COVER_SW_RESET REG_COVER_41
#define MSK_COVER_SW_RESET 0x0001

#define REG_ISPSC0_COVER_DB_EN REG_COVER_01
#define REG_ISPSC1_COVER_DB_EN REG_COVER_41
#define REG_ISPSC2_COVER_DB_EN REG_COVER_01
#define REG_ISPSC3_COVER_DB_EN REG_COVER_41
#define MSK_COVER_DB_EN 0x0002

#define REG_ISPSC0_COVER_VS_INV REG_COVER_01
#define REG_ISPSC1_COVER_VS_INV REG_COVER_41
#define REG_ISPSC2_COVER_VS_INV REG_COVER_01
#define REG_ISPSC3_COVER_VS_INV REG_COVER_41
#define MSK_COVER_VS_INV 0x0004

#define REG_ISPSC0_COVER_BWIN_TRIG REG_COVER_02
#define REG_ISPSC1_COVER_BWIN_TRIG REG_COVER_42
#define REG_ISPSC2_COVER_BWIN_TRIG REG_COVER_02
#define REG_ISPSC3_COVER_BWIN_TRIG REG_COVER_42
#define MSK_COVER_BWIN_TRIG 0x0001

#define REG_ISPSC0_COVER_BWIN0_EN REG_COVER_08
#define REG_ISPSC0_COVER_BWIN1_EN REG_COVER_10
#define REG_ISPSC0_COVER_BWIN2_EN REG_COVER_18
#define REG_ISPSC0_COVER_BWIN3_EN REG_COVER_20
#define REG_ISPSC1_COVER_BWIN0_EN REG_COVER_48
#define REG_ISPSC1_COVER_BWIN1_EN REG_COVER_50
#define REG_ISPSC1_COVER_BWIN2_EN REG_COVER_58
#define REG_ISPSC1_COVER_BWIN3_EN REG_COVER_60
#define REG_ISPSC2_COVER_BWIN0_EN REG_COVER_08
#define REG_ISPSC2_COVER_BWIN1_EN REG_COVER_10
#define REG_ISPSC2_COVER_BWIN2_EN REG_COVER_18
#define REG_ISPSC2_COVER_BWIN3_EN REG_COVER_20
#define REG_ISPSC3_COVER_BWIN0_EN REG_COVER_48
#define REG_ISPSC3_COVER_BWIN1_EN REG_COVER_50
#define REG_ISPSC3_COVER_BWIN2_EN REG_COVER_58
#define REG_ISPSC3_COVER_BWIN3_EN REG_COVER_60
#define MSK_COVER_BWIN_EN 0x0001
#define REG_COVER_BWIN_SHIFT BK_BASE_REG(0x8)
#define REG_COVER_PORT_SHIFT BK_BASE_REG(0x40)

#define REG_ISPSC0_COVER_BWIN0_H_STR REG_COVER_09
#define REG_ISPSC0_COVER_BWIN1_H_STR REG_COVER_11
#define REG_ISPSC0_COVER_BWIN2_H_STR REG_COVER_19
#define REG_ISPSC0_COVER_BWIN3_H_STR REG_COVER_21
#define REG_ISPSC1_COVER_BWIN0_H_STR REG_COVER_49
#define REG_ISPSC1_COVER_BWIN1_H_STR REG_COVER_51
#define REG_ISPSC1_COVER_BWIN2_H_STR REG_COVER_59
#define REG_ISPSC1_COVER_BWIN3_H_STR REG_COVER_61
#define REG_ISPSC2_COVER_BWIN0_H_STR REG_COVER_09
#define REG_ISPSC2_COVER_BWIN1_H_STR REG_COVER_11
#define REG_ISPSC2_COVER_BWIN2_H_STR REG_COVER_19
#define REG_ISPSC2_COVER_BWIN3_H_STR REG_COVER_21
#define REG_ISPSC3_COVER_BWIN0_H_STR REG_COVER_49
#define REG_ISPSC3_COVER_BWIN1_H_STR REG_COVER_51
#define REG_ISPSC3_COVER_BWIN2_H_STR REG_COVER_59
#define REG_ISPSC3_COVER_BWIN3_H_STR REG_COVER_61
#define MSK_COVER_BWIN_H_STR 0x1FFF

#define REG_ISPSC0_COVER_BWIN0_H_END REG_COVER_0A
#define REG_ISPSC0_COVER_BWIN1_H_END REG_COVER_12
#define REG_ISPSC0_COVER_BWIN2_H_END REG_COVER_1A
#define REG_ISPSC0_COVER_BWIN3_H_END REG_COVER_22
#define REG_ISPSC1_COVER_BWIN0_H_END REG_COVER_4A
#define REG_ISPSC1_COVER_BWIN1_H_END REG_COVER_52
#define REG_ISPSC1_COVER_BWIN2_H_END REG_COVER_5A
#define REG_ISPSC1_COVER_BWIN3_H_END REG_COVER_62
#define REG_ISPSC2_COVER_BWIN0_H_END REG_COVER_0A
#define REG_ISPSC2_COVER_BWIN1_H_END REG_COVER_12
#define REG_ISPSC2_COVER_BWIN2_H_END REG_COVER_1A
#define REG_ISPSC2_COVER_BWIN3_H_END REG_COVER_22
#define REG_ISPSC3_COVER_BWIN0_H_END REG_COVER_4A
#define REG_ISPSC3_COVER_BWIN1_H_END REG_COVER_52
#define REG_ISPSC3_COVER_BWIN2_H_END REG_COVER_5A
#define REG_ISPSC3_COVER_BWIN3_H_END REG_COVER_62
#define MSK_COVER_BWIN_H_END 0x1FFF

#define REG_ISPSC0_COVER_BWIN0_V_STR REG_COVER_0B
#define REG_ISPSC0_COVER_BWIN1_V_STR REG_COVER_13
#define REG_ISPSC0_COVER_BWIN2_V_STR REG_COVER_1B
#define REG_ISPSC0_COVER_BWIN3_V_STR REG_COVER_23
#define REG_ISPSC1_COVER_BWIN0_V_STR REG_COVER_4B
#define REG_ISPSC1_COVER_BWIN1_V_STR REG_COVER_53
#define REG_ISPSC1_COVER_BWIN2_V_STR REG_COVER_5B
#define REG_ISPSC1_COVER_BWIN3_V_STR REG_COVER_63
#define REG_ISPSC2_COVER_BWIN0_V_STR REG_COVER_0B
#define REG_ISPSC2_COVER_BWIN1_V_STR REG_COVER_13
#define REG_ISPSC2_COVER_BWIN2_V_STR REG_COVER_1B
#define REG_ISPSC2_COVER_BWIN3_V_STR REG_COVER_23
#define REG_ISPSC3_COVER_BWIN0_V_STR REG_COVER_4B
#define REG_ISPSC3_COVER_BWIN1_V_STR REG_COVER_53
#define REG_ISPSC3_COVER_BWIN2_V_STR REG_COVER_5B
#define REG_ISPSC3_COVER_BWIN3_V_STR REG_COVER_63

#define MSK_COVER_BWIN_V_STR 0x1FFF

#define REG_ISPSC0_COVER_BWIN0_V_END REG_COVER_0C
#define REG_ISPSC0_COVER_BWIN1_V_END REG_COVER_14
#define REG_ISPSC0_COVER_BWIN2_V_END REG_COVER_1C
#define REG_ISPSC0_COVER_BWIN3_V_END REG_COVER_24
#define REG_ISPSC1_COVER_BWIN0_V_END REG_COVER_4C
#define REG_ISPSC1_COVER_BWIN1_V_END REG_COVER_54
#define REG_ISPSC1_COVER_BWIN2_V_END REG_COVER_5C
#define REG_ISPSC1_COVER_BWIN3_V_END REG_COVER_64
#define REG_ISPSC2_COVER_BWIN0_V_END REG_COVER_0C
#define REG_ISPSC2_COVER_BWIN1_V_END REG_COVER_14
#define REG_ISPSC2_COVER_BWIN2_V_END REG_COVER_1C
#define REG_ISPSC2_COVER_BWIN3_V_END REG_COVER_24
#define REG_ISPSC3_COVER_BWIN0_V_END REG_COVER_4C
#define REG_ISPSC3_COVER_BWIN1_V_END REG_COVER_54
#define REG_ISPSC3_COVER_BWIN2_V_END REG_COVER_5C
#define REG_ISPSC3_COVER_BWIN3_V_END REG_COVER_64
#define MSK_COVER_BWIN_V_END 0x1FFF

#define REG_ISPSC0_COVER_BWIN0_REPLACE_R REG_COVER_0D
#define REG_ISPSC0_COVER_BWIN1_REPLACE_R REG_COVER_15
#define REG_ISPSC0_COVER_BWIN2_REPLACE_R REG_COVER_1D
#define REG_ISPSC0_COVER_BWIN3_REPLACE_R REG_COVER_25
#define REG_ISPSC1_COVER_BWIN0_REPLACE_R REG_COVER_4D
#define REG_ISPSC1_COVER_BWIN1_REPLACE_R REG_COVER_55
#define REG_ISPSC1_COVER_BWIN2_REPLACE_R REG_COVER_5D
#define REG_ISPSC1_COVER_BWIN3_REPLACE_R REG_COVER_65
#define REG_ISPSC2_COVER_BWIN0_REPLACE_R REG_COVER_0D
#define REG_ISPSC2_COVER_BWIN1_REPLACE_R REG_COVER_15
#define REG_ISPSC2_COVER_BWIN2_REPLACE_R REG_COVER_1D
#define REG_ISPSC2_COVER_BWIN3_REPLACE_R REG_COVER_25
#define REG_ISPSC3_COVER_BWIN0_REPLACE_R REG_COVER_4D
#define REG_ISPSC3_COVER_BWIN1_REPLACE_R REG_COVER_55
#define REG_ISPSC3_COVER_BWIN2_REPLACE_R REG_COVER_5D
#define REG_ISPSC3_COVER_BWIN3_REPLACE_R REG_COVER_65
#define MSK_COVER_BWIN_REPLACE_R 0x00FF

#define REG_ISPSC0_COVER_BWIN0_REPLACE_G REG_COVER_0D
#define REG_ISPSC0_COVER_BWIN1_REPLACE_G REG_COVER_15
#define REG_ISPSC0_COVER_BWIN2_REPLACE_G REG_COVER_1D
#define REG_ISPSC0_COVER_BWIN3_REPLACE_G REG_COVER_25
#define REG_ISPSC1_COVER_BWIN0_REPLACE_G REG_COVER_4D
#define REG_ISPSC1_COVER_BWIN1_REPLACE_G REG_COVER_55
#define REG_ISPSC1_COVER_BWIN2_REPLACE_G REG_COVER_5D
#define REG_ISPSC1_COVER_BWIN3_REPLACE_G REG_COVER_65
#define REG_ISPSC2_COVER_BWIN0_REPLACE_G REG_COVER_0D
#define REG_ISPSC2_COVER_BWIN1_REPLACE_G REG_COVER_15
#define REG_ISPSC2_COVER_BWIN2_REPLACE_G REG_COVER_1D
#define REG_ISPSC2_COVER_BWIN3_REPLACE_G REG_COVER_25
#define REG_ISPSC3_COVER_BWIN0_REPLACE_G REG_COVER_4D
#define REG_ISPSC3_COVER_BWIN1_REPLACE_G REG_COVER_55
#define REG_ISPSC3_COVER_BWIN2_REPLACE_G REG_COVER_5D
#define REG_ISPSC3_COVER_BWIN3_REPLACE_G REG_COVER_65
#define MSK_COVER_BWIN_REPLACE_G 0xFF00

#define REG_ISPSC0_COVER_BWIN0_REPLACE_B REG_COVER_0E
#define REG_ISPSC0_COVER_BWIN1_REPLACE_B REG_COVER_16
#define REG_ISPSC0_COVER_BWIN2_REPLACE_B REG_COVER_1E
#define REG_ISPSC0_COVER_BWIN3_REPLACE_B REG_COVER_26
#define REG_ISPSC1_COVER_BWIN0_REPLACE_B REG_COVER_4E
#define REG_ISPSC1_COVER_BWIN1_REPLACE_B REG_COVER_56
#define REG_ISPSC1_COVER_BWIN2_REPLACE_B REG_COVER_5E
#define REG_ISPSC1_COVER_BWIN3_REPLACE_B REG_COVER_66
#define REG_ISPSC2_COVER_BWIN0_REPLACE_B REG_COVER_0E
#define REG_ISPSC2_COVER_BWIN1_REPLACE_B REG_COVER_16
#define REG_ISPSC2_COVER_BWIN2_REPLACE_B REG_COVER_1E
#define REG_ISPSC2_COVER_BWIN3_REPLACE_B REG_COVER_26
#define REG_ISPSC3_COVER_BWIN0_REPLACE_B REG_COVER_4E
#define REG_ISPSC3_COVER_BWIN1_REPLACE_B REG_COVER_56
#define REG_ISPSC3_COVER_BWIN2_REPLACE_B REG_COVER_5E
#define REG_ISPSC3_COVER_BWIN3_REPLACE_B REG_COVER_66
#define MSK_COVER_BWIN_REPLACE_B 0x00FF

// DIP COVER settings, bank0x1618
#define REG_DIP_COVER_SW_RESET REG_COVER_01
#define REG_DIP_COVER_DB_EN REG_COVER_01
#define REG_DIP_COVER_VS_INV REG_COVER_01
#define REG_DIP_COVER_BWIN_TRIG REG_COVER_02

#define REG_DIP_COVER_BWIN0_EN REG_COVER_08
#define REG_DIP_COVER_BWIN1_EN REG_COVER_10
#define REG_DIP_COVER_BWIN2_EN REG_COVER_18
#define REG_DIP_COVER_BWIN3_EN REG_COVER_20

#define REG_DIP_COVER_BWIN0_H_STR REG_COVER_09
#define REG_DIP_COVER_BWIN1_H_STR REG_COVER_11
#define REG_DIP_COVER_BWIN2_H_STR REG_COVER_19
#define REG_DIP_COVER_BWIN3_H_STR REG_COVER_21

#define REG_DIP_COVER_BWIN0_H_END REG_COVER_0A
#define REG_DIP_COVER_BWIN1_H_END REG_COVER_12
#define REG_DIP_COVER_BWIN2_H_END REG_COVER_1A
#define REG_DIP_COVER_BWIN3_H_END REG_COVER_22

#define REG_DIP_COVER_BWIN0_V_STR REG_COVER_0B
#define REG_DIP_COVER_BWIN1_V_STR REG_COVER_13
#define REG_DIP_COVER_BWIN2_V_STR REG_COVER_1B
#define REG_DIP_COVER_BWIN3_V_STR REG_COVER_23

#define REG_DIP_COVER_BWIN0_V_END REG_COVER_0C
#define REG_DIP_COVER_BWIN1_V_END REG_COVER_14
#define REG_DIP_COVER_BWIN2_V_END REG_COVER_1C
#define REG_DIP_COVER_BWIN3_V_END REG_COVER_24

#define REG_DIP_COVER_BWIN0_REPLACE_R REG_COVER_0D
#define REG_DIP_COVER_BWIN1_REPLACE_R REG_COVER_15
#define REG_DIP_COVER_BWIN2_REPLACE_R REG_COVER_1D
#define REG_DIP_COVER_BWIN3_REPLACE_R REG_COVER_25

#define REG_DIP_COVER_BWIN0_REPLACE_G REG_COVER_0D
#define REG_DIP_COVER_BWIN1_REPLACE_G REG_COVER_15
#define REG_DIP_COVER_BWIN2_REPLACE_G REG_COVER_1D
#define REG_DIP_COVER_BWIN3_REPLACE_G REG_COVER_25

#define REG_DIP_COVER_BWIN0_REPLACE_B REG_COVER_0E
#define REG_DIP_COVER_BWIN1_REPLACE_B REG_COVER_16
#define REG_DIP_COVER_BWIN2_REPLACE_B REG_COVER_1E
#define REG_DIP_COVER_BWIN3_REPLACE_B REG_COVER_26


#endif /* __HAL_COVER_REG_H__ */
